/* ***************************************************** **
   ch01_correlating_inline_views.sql
   
   Skrypt dla książki Praktyczna nauka SQL dla Oracle, Helion (2022),
   napisanej przez Kima Berga Hansena, https://www.kibeha.dk
   Używasz na własną odpowiedzialność.
   *****************************************************
   
   Rozdział 1.
   Korelacja widoków osadzonych
   
   Skrypt przeznaczony do wykonania w schemacie PRACTICAL
** ***************************************************** */

/* -----------------------------------------------------
   Konfiguracja formatowania sqlcl
   ----------------------------------------------------- */

set pagesize 80
set linesize 80
set sqlformat ansiconsole

/* -----------------------------------------------------
   Przykładowe fragmenty kodu do rozdziału 1.
   ----------------------------------------------------- */

-- Listing 1.1. Roczna sprzedaż trzech rodzajów piwa pochodzących z browaru Balthazar Brauerei

select
   bp.brewery_name
 , bp.product_id as p_id
 , bp.product_name
 , ys.yr
 , ys.yr_qty
from brewery_products bp
join yearly_sales ys
   on ys.product_id = bp.product_id
where bp.brewery_id = 518
order by bp.product_id, ys.yr;

-- Listing 1.2. Pobieranie dwóch kolumn z danymi dotyczącymi najlepiej sprzedającego się piwa w roku

select
   bp.brewery_name
 , bp.product_id as p_id
 , bp.product_name
 , (
      select ys.yr
      from yearly_sales ys
      where ys.product_id = bp.product_id
      order by ys.yr_qty desc
      fetch first row only
   ) as yr
 , (
      select ys.yr_qty
      from yearly_sales ys
      where ys.product_id = bp.product_id
      order by ys.yr_qty desc
      fetch first row only
   ) as yr_qty
from brewery_products bp
where bp.brewery_id = 518
order by bp.product_id;

-- Listing 1.3. Użycie pojedynczego podzapytania skalarnego i konkatenacji wartości

select
   brewery_name
 , product_id as p_id
 , product_name
 , to_number(
      substr(yr_qty_str, 1, instr(yr_qty_str, ';') - 1)
   ) as yr
 , to_number(
      substr(yr_qty_str, instr(yr_qty_str, ';') + 1)
   ) as yr_qty
from (
   select
      bp.brewery_name
    , bp.product_id
    , bp.product_name
    , (
         select ys.yr || ';' || ys.yr_qty
         from yearly_sales ys
         where ys.product_id = bp.product_id
         order by ys.yr_qty desc
         fetch first row only
      ) as yr_qty_str
   from brewery_products bp
   where bp.brewery_id = 518
)
order by product_id;

-- Listing 1.4. Używanie funkcji analitycznych w celu pobrania wszystkich żądanych kolumn

select
   brewery_name
 , product_id as p_id
 , product_name
 , yr
 , yr_qty
from (
   select
      bp.brewery_name
    , bp.product_id
    , bp.product_name
    , ys.yr
    , ys.yr_qty
    , row_number() over (
         partition by bp.product_id
         order by ys.yr_qty desc
      ) as rn
   from brewery_products bp
   join yearly_sales ys
      on ys.product_id = bp.product_id
   where bp.brewery_id = 518
)
where rn = 1
order by product_id;

-- Listing 1.5. Osiągnięcie tego samego efektu za pomocą widoku osadzonego

select
   bp.brewery_name
 , bp.product_id as p_id
 , bp.product_name
 , top_ys.yr
 , top_ys.yr_qty
from brewery_products bp
cross join lateral(
   select
      ys.yr
    , ys.yr_qty
   from yearly_sales ys
   where ys.product_id = bp.product_id
   order by ys.yr_qty desc
   fetch first row only
) top_ys
where bp.brewery_id = 518
order by bp.product_id;

-- Tradycyjny styl klauzuli from bez klauzuli cross join w stylu ANSI

select
   bp.brewery_name
 , bp.product_id as p_id
 , bp.product_name
 , top_ys.yr
 , top_ys.yr_qty
from brewery_products bp
, lateral(
   select
      ys.yr
    , ys.yr_qty
   from yearly_sales ys
   where ys.product_id = bp.product_id
   order by ys.yr_qty desc
   fetch first row only
) top_ys
where bp.brewery_id = 518
order by bp.product_id;

-- Złączenie join lateral i predykat w klauzuli on

select
   bp.brewery_name
 , bp.product_id as p_id
 , bp.product_name
 , top_ys.yr
 , top_ys.yr_qty
from brewery_products bp
join lateral(
   select
      ys.yr
    , ys.yr_qty
   from yearly_sales ys
   where ys.product_id = bp.product_id
   order by ys.yr_qty desc
   fetch first row only
) top_ys
   on 1=1
where bp.brewery_id = 518
order by bp.product_id;

-- Listing 1.6. Alternatywna składnia oparta na klauzuli cross apply

select
   bp.brewery_name
 , bp.product_id as p_id
 , bp.product_name
 , top_ys.yr
 , top_ys.yr_qty
from brewery_products bp
cross apply(
   select
      ys.yr
    , ys.yr_qty
   from yearly_sales ys
   where ys.product_id = bp.product_id
   order by ys.yr_qty desc
   fetch first row only
) top_ys
where bp.brewery_id = 518
order by bp.product_id;

-- Listing 1.7. Używanie klauzuli outer apply, gdy potrzebna jest funkcjonalność złączenia typu outer

select
   bp.brewery_name
 , bp.product_id as p_id
 , bp.product_name
 , top_ys.yr
 , top_ys.yr_qty
from brewery_products bp
outer apply(
   select
      ys.yr
    , ys.yr_qty
   from yearly_sales ys
   where ys.product_id = bp.product_id
   and ys.yr_qty < 400
   order by ys.yr_qty desc
   fetch first row only
) top_ys
where bp.brewery_id = 518
order by bp.product_id;

-- Listing 1.8. Złączenie typu outer wykorzystujące słowo kluczowe lateral

select
   bp.brewery_name
 , bp.product_id as p_id
 , bp.product_name
 , top_ys.yr
 , top_ys.yr_qty
from brewery_products bp
left outer join lateral(
   select
      ys.yr
    , ys.yr_qty
   from yearly_sales ys
   where ys.product_id = bp.product_id
   order by ys.yr_qty desc
   fetch first row only
) top_ys
   on top_ys.yr_qty < 500
where bp.brewery_id = 518
order by bp.product_id;

/* ***************************************************** */
